using System;
using System.ComponentModel;
using System.Collections;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.UmlRt;
using Borland.Eco.UmlCodeAttributes;


namespace AssociationClassDemo
{

	[UmlCollection(typeof(Participation))]
	public interface IParticipationList : ICollection
	{
		#region ECO generated code
		Participation this[int index]
		{
			get;
			set;
		}
		int Add(Participation value);
		bool Contains(Participation value);
		int IndexOf(Participation value);
		void Insert(int index, Participation value);
		void Remove(Participation value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Member))]
	public interface IMemberList : ICollection
	{
		#region ECO generated code
		Member this[int index]
		{
			get;
			set;
		}
		int Add(Member value);
		bool Contains(Member value);
		int IndexOf(Member value);
		void Insert(int index, Member value);
		void Remove(Member value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Group))]
	public interface IGroupList : ICollection
	{
		#region ECO generated code
		Group this[int index]
		{
			get;
			set;
		}
		int Add(Group value);
		bool Contains(Group value);
		int IndexOf(Group value);
		void Insert(int index, Group value);
		void Remove(Group value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
	[UmlElement("Package", Id="8f9ae6a0-1e26-44d1-833c-c374517d6435")]
	[EcoCodeGenVersion("2.0")]
	[UmlMetaAttribute("ownedElement", typeof(Group))]
	[UmlMetaAttribute("ownedElement", typeof(Member))]
	[UmlMetaAttribute("ownedElement", typeof(Participation))]
	public abstract class CoreClassesPackage
	{
		
		[UmlElement("Association", Id="731c9a17-ce15-4b24-aabb-7eb86373408b")]
		public class Participation
		{
		}
	}
	[UmlElement(Id="a4d936d7-bf10-497e-aee4-fcc1b05801fb")]
	[UmlTaggedValue("Eco.DefaultStringRepresentation", "Name")]
	public class Group : ILoopBack
	{
		
		public class GroupListAdapter : ObjectListAdapter, IGroupList
		{
			public GroupListAdapter(IList source) : 
					base(source)
			{
			}
			public Group this[int index]
			{
				get
				{
					return ((Group)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Group value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Group value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Group value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Group value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Group value)
			{
				this.Adaptee.Remove(value);
			}
		}
		
		#region Autogenerated ECO code
		
		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
		
		public Group(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 3);
			public const int Name = Eco_FirstMember;
			public const int Member = (Name + 1);
			public const int Participation = (Member + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		
		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		[LinkRole("a0d2e5fc-20d3-4fbf-8991-0822557cbddf")]
		public IParticipationList Participation
		{
			get
			{
				return new Participation.ParticipationListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Participation))));
			}
		}
		
		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
		
		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
		
		#endregion Autogenerated ECO code

		public Group(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
				// User code here
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}

		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Member, Id="a0d2e5fc-20d3-4fbf-8991-0822557cbddf")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Participation), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		[UmlTaggedValue("Eco.Ordered", "True")]
		public IMemberList Member
		{
			get
			{
				return new Member.MemberListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Member))));
			}
		}
		[UmlElement(Id="dab3994a-fe00-450c-ba93-6edb3575380c", Index=Eco_LoopbackIndices.Name)]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}

	}
	[UmlElement(Id="647f9079-c4a9-497e-a513-84f6608f704e")]
	[UmlTaggedValue("Eco.DefaultStringRepresentation", "Name")]
	public class Member : ILoopBack
	{
		
		public class MemberListAdapter : ObjectListAdapter, IMemberList
		{
			public MemberListAdapter(IList source) : 
					base(source)
			{
			}
			public Member this[int index]
			{
				get
				{
					return ((Member)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Member value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Member value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Member value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Member value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Member value)
			{
				this.Adaptee.Remove(value);
			}
		}
		
		#region Autogenerated ECO code
		
		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
		
		public Member(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 3);
			public const int Name = Eco_FirstMember;
			public const int Group = (Name + 1);
			public const int Participation = (Group + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		
		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		[LinkRole("549ab0ce-3a87-4cf8-91e9-6dfbf153f583")]
		public IParticipationList Participation
		{
			get
			{
				return new Participation.ParticipationListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Participation))));
			}
		}
		
		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
		
		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
		
		#endregion Autogenerated ECO code

		/*
		public Member(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{

				#line 458 "C:\dev\main\bold\demos\Examples\CSharp\ECO\AssociationClass\CoreClasses.cs"
				this.Deinitialize(serviceProvider);

				#line default

				#line 459 "C:\dev\main\bold\demos\Examples\CSharp\ECO\AssociationClass\CoreClasses.cs"
				throw;

				#line default
			}
		}
		*/
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Group, Id="549ab0ce-3a87-4cf8-91e9-6dfbf153f583")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Participation), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		[UmlTaggedValue("Eco.Ordered", "True")]
		public IGroupList Group
		{
			get
			{
				return new Group.GroupListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Group))));
			}
		}
		[UmlElement(Id="0d63d2d7-0dff-4174-81d9-16bd522b73ea", Index=Eco_LoopbackIndices.Name)]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		
		public Member(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
				// User code here
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
	}
	[UmlElement(Id="03f8c8b3-0881-4f5c-9122-4a01a1958394")]
	[UmlMetaAttribute("association", typeof(CoreClassesPackage.Participation))]
	public class Participation : ILoopBack
	{
		
		public class ParticipationListAdapter : ObjectListAdapter, IParticipationList
		{
			public ParticipationListAdapter(IList source) : 
					base(source)
			{
			}
			public Participation this[int index]
			{
				get
				{
					return ((Participation)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Participation value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Participation value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Participation value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Participation value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Participation value)
			{
				this.Adaptee.Remove(value);
			}
		}
		
		#region Autogenerated ECO code
		
		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
		
		public Participation(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 3);
			public const int Role = Eco_FirstMember;
			public const int Member = (Role + 1);
			public const int Group = (Member + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		
		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		[InnerLink("a0d2e5fc-20d3-4fbf-8991-0822557cbddf")]
		public Member Member
		{
			get
			{
				return ((Member)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Member)));
			}
		}
		
		[InnerLink("549ab0ce-3a87-4cf8-91e9-6dfbf153f583")]
		public Group Group
		{
			get
			{
				return ((Group)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Group)));
			}
		}
		
		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
		
		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
		
		#endregion Autogenerated ECO code

		public Participation(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
				// User code here
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}

		[UmlElement(Id="816d7db5-0b5a-466f-ad57-30115df5369b", Index=Eco_LoopbackIndices.Role)]
		public string Role
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Role)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Role, ((object)(value)));
			}
		}
	}
}
